<!DOCTYPE HTML>

<html>

<head>
<!--[if IE]>
    <meta http-equiv="imagetoolbar" content="no" />
<![endif]-->

<title>Pomoc</title>
<meta charset="iso-8859-2" />
<meta name="author" content="Maciej Radzikowski" />
<link rel="Shortcut icon" href="../../../favicon.ico" />

<style type="text/css">
@import '../../../pliki/css/reset.css';

body { background: #fff url(../../../grafika/std/pomoc.png) bottom left no-repeat; overflow:hidden; width:500px; height:480px; font-family: Verdana, Arial, sans-serif; font-size: 13px; }

ul { list-style-type: square; }
ul ul { list-style-type: circle; }
a { text-decoration: none; color: #005; }
a:hover { color: #00a; }

h1 { font-weight: bold; margin-bottom: 5px; font-size: 15px; line-height:15px; text-align: center; }
a.button { height: 16px; color: #000; font-size: 11px; float: left; padding: 3px 3px 0; margin-right: 3px; background: #fff; border: 1px solid #bbb; }

#tresc { position:absolute; width:318px; height:446px; left:165px; top:17px; overflow:auto; }
a#powrot { position:absolute; width:147px; height:38px; background:url(../../../grafika/std/pomoc_buttony.png) no-repeat; }
a#powrot:hover { background-position:-147px 0; }

div.img { width: 20px; height: 20px; display: block; float: left; background: url(button_bg_silver) no-repeat; border-bottom: 1px solid #bbb; }
div.img:hover { background-position: -0 -22px; }
div.img:active { background-position: -0 -44px; }
div.img.left { border-left: 1px solid #bbb; }
div.img.right { border-right: 1px solid #bbb; margin-right: 3px; }
div.clear { clear: both; }

a.img { display: block; width: 20px; height: 20px; background: url(icons.gif) no-repeat; }
a.img.cofnij { background-position: -160px 0; }
a.img.ponow { background-position: -100px 0; }
a.img.wytnij { background-position: -300px 0; }
a.img.kopiuj { background-position: -280px 0; }
a.img.wklej { background-position: -560px 0; }
a.img.szukaj { background-position: -520px -20px; }
a.img.zamien { background-position: -500px -20px; }
a.img.formatowanie { background-position: -580px 0; }
a.img.czyszczenie { background-position: -520px 0; }
a.img.tabela { background-position: -580px -20px; }
a.img.bold { background-position: 0 0; }
a.img.italic { background-position: -60px 0; }
a.img.under { background-position: -140px 0; }
a.img.strike { background-position: -120px 0; }
a.img.sub { background-position: -600px 0; }
a.img.sup { background-position: -620px 0; }
a.img.lewo { background-position: -460px 0; }
a.img.srodek { background-position: -420px 0; }
a.img.prawo { background-position: -480px 0; }
a.img.justuj { background-position: -440px 0; }
a.img.kolor { background-position: -720px 0; }
a.img.tlo { background-position: -760px 0; }
a.img.wciecie { background-position: -400px 0; }
a.img.zmniejsz_wciecie { background-position: -540px 0; }
a.img.punkty { background-position: -20px 0; }
a.img.numeracja { background-position: -80px 0; }
a.img.link { background-position: -500px 0; }
a.img.usun_link { background-position: -640px 0; }
a.img.kotwica { background-position: -200px 0; }
a.img.obrazek { background-position: -380px 0; }
a.img.media { background-position: -320px -20px; }
a.img.rozwijanie { background: url(rozwijanie.png) no-repeat; }
a.img.spacja { background-position: -340px -20px; }
a.img.symbol { background-position: -240px 0; }
a.img.akronim { background-position: -880px -20px; }
a.img.linia { background-position: -360px 0; }
a.img.widocznosc { background-position: -660px 0; }
a.img.fullscreen { background-position: -100px -20px; }
a.img.html { background-position: -260px 0; }
</style>

</head>

<body>

<?
function cofnij()
{
echo 'cofnij i ponw</h1>
<div class="img left"><a href="javascript:void(0)" class="img cofnij"></a></div><div class="img right"><a href="javascript:void(0)" class="img ponow"></a></div><div class="clear"></div>
Przyciski "cofnij" i "ponw" pozwalaj, tak jak w zwykym edytorze tekstu, na anulowanie wprowadzonych przed chwil zmian bd ich przywrcenie.
Cho limit cofni, ktre mona wykona, jest ogromny, naley pamita, e mona w ten sposb wrci maksymalnie do wersji, ktra zostaa poprzednio zapisana.
<br /><br />Operacje te mona wykona stosujc take odpowiednio skrty klawiszowe <kbd>Ctrl+Z</kbd> i <kbd>Ctrl+Y</kbd>.';
}

function operacje()
{
echo 'wytnij, kopiuj, wklej</h1>
<div class="img left"><a href="javascript:void(0)" class="img wytnij"></a></div><div class="img"><a href="javascript:void(0)" class="img kopiuj"></a></div><div class="img right"><a href="javascript:void(0)" class="img wklej"></a></div><div class="clear"></div>
Przyciski te pozwalaj wyci bd skopiowa zaznaczony tekst i obiekty oraz wklei w inne miejsce w dokumencie bd w innym programie.
Wklei mona take skopiowan wczeniej tre z innych edytorw, np. Worda.
<br /><br />Uywajc tych opcji wycinane, kopiowane bd wklejana s take style, wic jeli kopiujemy pogrubiony tekst lub tabelk z Worda, bez problemu zostanie to wstawione na stron.
<br /><br />Operacje te mona wykona stosujc take odpowiednio skrty klawiszowe <kbd>Ctrl+X</kbd>, <kbd>Ctrl+C</kbd> i <kbd>Ctrl+V</kbd>.
<br />Aby wyci, skopiowa bd wklei sam tekst, bez formatowania, naley uy skrtw klawiszowych <kbd>Ctrl+Shift+X</kbd>, <kbd>Ctrl+Shift+C</kbd> i <kbd>Ctrl+Shift+V</kbd>.';
}

function szukaj()
{
echo 'znajd i zamie</h1>
<div class="img left"><a href="javascript:void(0)" class="img szukaj"></a></div><div class="img right"><a href="javascript:void(0)" class="img zamien"></a></div><div class="clear"></div>
Przyciski te otwieraj okienko pozwalajce na odnalezienie w dokumencie interesujcego nas fragmentu w gr lub w d od pozycji kursora.
Dodatkowo wybierajc opcj "zamie" mona zamienia istniejce w dokumencie fragmenty tekstu na inne:
<ul>
 <li>pojedynczo, za kadym razem sprawdzajc, czy na pewno ten fragment chcemy przeksztaci, klikajc przyciski "Znajd nastpny", by doj do interesujcej nas pozycji, i "Zamie",</li>
 <li>wszystkie naraz, uywajc przycisku "Zamie wszystko".</li>
</ul>
<br />Okienko wyszukiwania otworzy mona take uywajc skrtu klawiszowego <kbd>Ctrl+F</kbd>.';
}

function formatowanie()
{
echo 'usu formatowanie</h1>
<div class="img left right"><a href="javascript:void(0)" class="img formatowanie"></a></div><div class="clear"></div>
Przycisk ten pozwala usun wszystkie style na zaznaczonym obszarze, pozostawiajc jedynie sam czysty, niesformatowany tekst i elementy.';
}

function czyszczenie()
{
echo 'wyczy zawarto</h1>
<div class="img left right"><a href="javascript:void(0)" class="img czyszczenie"></a></div><div class="clear"></div>
Przycisk ten usuwa ca zawarto edytora.';
}

function tabela()
{
echo 'wstaw now tabel</h1>
<div class="img left right"><a href="javascript:void(0)" class="img tabela"></a></div><div class="clear"></div>
Przycisk ten otwiera okinko pozwalajce ustawi wygld i waciwoci nowej tabelki, po czym wstawi j w miejscu kursora:
<ul>
 <li>kolumny i wiersze - ilo pocztkowych kolumn i wierszy, ktr mona pniej zmieni dodajc nowe bd usuwajc istniejce,</li>
 <li>ramka - szeroko obramowania; po ustawieniu wartoci wikszej od 0 kolor mona zmieni w zakadce "Zaawansowane",</li>
 <li>kolor ta - zmieni go mona w zakadce "Zaawansowane"</li>
 <li>szeroko i wysoko - domylna szeroko i wysoko tabeli; poda j mona w pixelach wstawiajc jedynie liczb bd w procentach szerokoci dokumentu, dodajc po liczbie znak "%".</li>
</ul>
<br />Ustawiajc kursor w istniejcej tabeli i klikajc na niej prawym przyciskiem myszy mona:
<ul>
 <li>utworzy w niej now tabel</li>
 <li>otworzy ponownie okno waciwoci tabeli (mona to zrobi take ustawiajc kursor w tabeli i klikajc podwietlony przycisk wstawiania tabeli)</li>
 <li>usun tabel.</li>
</ul>
<br />Ustawiajc kursor w istniejcej tabeli aktywne robi si przyciski na prawo od przycisku wstawiania tabeli, za pomoc ktrych mona:
<ul>
 <li>nada waciwoci poszczeglnym wierszom i komrkom,</li>
 <li>doda nowe wiersze powyej bd poniej wiersza, w ktrym ustawiony jest kursor,</li>
 <li>doda nowe kolumny na prawo bd lewo od kolumny, w ktrej ustawiony jest kursor,</li>
 <li>usun wiersze i kolumny,</li>
 <li>poczy zaznaczone kolumny bd wiersze oraz z powrotem je rozdzieli.</li>
</ul>
<br />Dziki tabeli mona zaprezentowa dane tabelaryczne, ale take m. in.:
<ul>
 <li>stworzy obszar z kolorowym tem (tworzc tabel o jednej komrce i nadajc jej to),</li>
 <li>umieci wiele elementw obok siebie (tworzc tabel i umieszczajc tre i obiekty w jej kolejnych kolumnach).</li>
</ul>';
}

function style()
{
echo 'pogrubienie, kursywa, podkrelenie, skrelenie</h1>
<div class="img left"><a href="javascript:void(0)" class="img bold"></a></div><div class="img"><a href="javascript:void(0)" class="img italic"></a></div><div class="img"><a href="javascript:void(0)" class="img under"></a></div><div class="img right"><a href="javascript:void(0)" class="img strike"></a></div><div class="clear"></div>
Przyciski te pozwalaj nada dany styl zaznaczonemu fragmentowi tekstu bd wczy wybrany styl, by mia go tekst pisany od tej pory do czasu wyczenia ponownym klikniciem przycisku. Style te mog by uywane rwnoczenie.';
}

function indeksy()
{
echo 'indeks dolny i grny</h1>
<div class="img left"><a href="javascript:void(0)" class="img sub"></a></div><div class="img right"><a href="javascript:void(0)" class="img sup"></a></div><div class="clear"></div>
Przyciski te pozwalaj przeksztaci zaznaczony tekst w indeks grny lub dolny bd wczy wybrany indeks, by by nim tekst pisany od tej pory do czasu wyczenia ponownym klikniciem przycisku.';
}

function wyrownanie()
{
echo 'wyrwnanie do lewej i prawej, wyrodkowanie i wyjustowanie</h1>
<div class="img left"><a href="javascript:void(0)" class="img lewo"></a></div><div class="img"><a href="javascript:void(0)" class="img srodek"></a></div><div class="img"><a href="javascript:void(0)" class="img prawo"></a></div><div class="img right"><a href="javascript:void(0)" class="img justuj"></a></div><div class="clear"></div>
Przyciski te pozwalaj ustali wyrwnanie akapitu, w ktrym obecnie znajduje si kursor, bd zaznaczonych elementw.
Aby wyczy dan opcj naley ponownie nacin jej przycisk.
<br /><br />Opcja ta pozwala rwnie na ustawienie opywania przez tekst niektrych elementw, np. tabeli czy obrazu.
Po wybraniu dla takiego elementu wyrwnania do prawej bd lewej strony dalszy tekst bdzie umieszczony z drugiej strony obiektu.
<br />Wstawiane obrazy domylnie maj ustawione wyrwnanie do lewej strony, ktre mona wyczy klikajc przycisk tego wyrwnania.';
}

function format()
{
echo 'format tekstu</h1>
<a href="javascript:void(0)" class="button">Akapit</a><div class="clear"></div>
Lista pozwala na wybranie formatu tekstu dla akapitu, w ktrym obecnie znajduje si kursor:
<ul>
 <li>akapit - domylny styl tekstu,</li>
 <li>staa szeroko - tekst wywietlany czcionk, w ktrej kady znak ma tak sam szeroko; dodatkowo w tekcie tym biae znaki, np. spacje, umieszczone obok siebie bd wielokrotnie wywietlone</li>
 <li>nagwek - styl nagwkw kolejnych rzdw dla akapitw; stosowanie tych nagwkw, prcz lepszego podziau tekstu dla czytelnika, pozwala wyszukiwarkom internetowym na lepsze okrelenie zawartoci strony, co skutkuje czstszymi wynikami w Google.</li>
</ul>';
}

function czcionka()
{
echo 'czcionka tekstu</h1>
<a href="javascript:void(0)" class="button">Czcionka</a><div class="clear"></div>
Lista pozwala na wybranie czcionki zaznaczonego tekstu bd wczenie wybranej czcionki, by by ni pisany tekst od tej pory do czasu wybrania innej.
Zazwyczaj domyln czcionk na stronie jest <code>Verdana</code>.';
}

function rozmiar()
{
echo 'rozmiar tekstu</h1>
<a href="javascript:void(0)" class="button">Rozmiar</a><div class="clear"></div>
Lista pozwala na wybranie wielkoci czcionki zaznaczonego tekstu bd wczenie wybranej wielkoci, by by ni pisany tekst od tej pory do czasu wybrania innej.
Zazwyczaj domyln wielkoci czcionki na stronie jest <code>12px</code> bd <code>13px</code>.
<br /><br />Wybrana wielko, z powodu innej jednostki miary, nie pokrywa si z wielkociami dostpnymi np. w edytorze Word. Pozwala to jednak na wstawienie tekstu, ktry bdzie podobnie wyglda w odniesieniu do reszty strony na rnych komputerach.';
}

function kolor()
{
echo 'kolor tekstu i ta</h1>
<div class="img left"><a href="javascript:void(0)" class="img kolor"></a></div><div class="img right"><a href="javascript:void(0)" class="img tlo"></a></div><div class="clear"></div>
Przyciski te pozwalaj na ustawienie wybranego koloru czcionki dla zaznaczonego tekstu lub jego ta bd wczenie wybranego koloru dla tekstu od tej pory do czasu wyczenia ponownym klikniciem na przycisk.
<br />Wybranie innego koloru moliwe jest dziki palecie otwieranej po klikniciu strzaki obok przycisku.';
}

function wciecie()
{
echo 'zwikszanie i zmniejszanie wcicia</h1>
<div class="img left"><a href="javascript:void(0)" class="img wciecie"></a></div><div class="img right"><a href="javascript:void(0)" class="img zmniejsz_wciecie"></a></div><div class="clear"></div>
Przyciski te pozwalaj zwikszy bd zmniejszy utworzone wcicie, oddalajc bd przybliajc krawd akapitu do lewego brzegu strony.
<br />Za pomoc tych przyciskw mona take zmniejszy lub zwikszy poziom elementu bd zaznaczonych elementw istniejcej <a href="?pomoc=lista">listy</a>, tworzc podpunkty.';
}

function lista()
{
echo 'lista wypunktowana i numerowana</h1>
<div class="img left"><a href="javascript:void(0)" class="img punkty"></a></div><div class="img right"><a href="javascript:void(0)" class="img numeracja"></a></div><div class="clear"></div>
Przyciski te pozwalaj zmieni zaznaczone akapity w kolejne elementy listy wypunktowanej lub numerowanej bd rozpocz tworzenie listy.
Wyczy list mona klikajc ponownie na podwietlonym przycisku listy lub naciskajc <kbd>Enter</kbd> w nowym, pustym elemencie listy.
<br />Klikajc strzak obok przycisku mona wybra styl punktw bd numerw listy.
<br /><br />Klikajc przyciski <a href="?pomoc=wciecie">wcicia</a> mona zmniejszy bd zwikszy poziom elementu bd zaznaczonych elementw listy, tworzc podpunkty.';
}

function wstaw_link()
{
echo 'wstaw i usu link</h1>
<div class="img left"><a href="javascript:void(0)" class="img link"></a></div><div class="img right"><a href="javascript:void(0)" class="img usun_link"></a></div><div class="clear"></div>
Przycisk te pozwalaj na zamienienie zaznaczonego tekstu bd elementu w link bd usunicie istniejcego linku.
<br />Po otwarciu okienka do wstawienia nowego linku mona ustawi w nim m. in:
<ul>
 <li>link URL - adres (skopiowany z paska przegldarki), do ktrego prowadzi ma hipercze, np.:
  <ul>
   <li><kbd>http://google.pl</kbd> - dla linku do strony zewntrznej (konieczny przedrostek <kbd>http://</kbd>),</li>
   <li><kbd>Podstrona,2.html</kbd> - dla linku do podstrony witryny,</li>
   <li><kbd>Podstrona,2.html#nazwa_kotwicy</kbd> - dla linku do <a href="?pomoc=kotwica">kotwicy</a> na innej stronie,</li>
   <li><kbd>mailto:adres@domena.pl</kbd> - dla linku do adresu e-mail,</li>
  </ul>
 </li>
 <li>wgrany plik - wybrany z listy (zaadowany wczeniej w mediach w panelu administracji) plik, ktry zostanie otwarty/pobrany po klikniciu linku,</li>
 <li>kotwica - <a href="?pomoc=kotwica">utworzone wczeniej</a> miejsce w dokumencie, do ktrego prowadzi ma link</li>
 <li>tytu - opis linku wywietlany po najechaniu na niego kursorem myszy.</li>
</ul>
<br />Edytowa ustawienia mona ustawiajc kursor na linku lub zaznaczajc go i klikajc przycisk dodawania linku.
<br /><br />Zaznaczajc wikszy fragment tekstu i klikajc przycisk usuwania linku usunite zostaj wszystkie zawierajce si w zaznaczeniu hipercza.';
}

function kotwica()
{
echo 'wstaw kotwic</h1>
<div class="img left right"><a href="javascript:void(0)" class="img kotwica"></a></div><div class="clear"></div>
Przycisk ten pozwala na wstawienie w miejscu kursora kotwicy, do ktrej utworzy mona <a href="?pomoc=wstaw_link">link</a> przenoszcy na jej wysoko.
Przydatne to moe by np. w przypadku dugiego artykuu ze spisem treci - kotwice wstawione przy nagwkach i linki do nich pozwol czytelnikowi na szybkie przejcie do interesujcego go fragmentu.
<br /><br />Link do kotwicy moe mie adres:
<ul>
 <li><kbd>#nazwa_kotwicy</kbd> - dla kotwicy w tym samym dokumencie,</li>
 <li><kbd>Podstrona,2.html#nazwa_kotwicy</kbd> - dla kotwicy na innej podstronie.</li>
</ul>';
}

function obrazek()
{
echo 'wstawianie obrazu</h1>
<div class="img left right"><a href="javascript:void(0)" class="img obrazek"></a></div><div class="clear"></div>
Przycisk pozwala na wstawienie obrazu w miejscu kursora.
W otwartym okienku mona ustawi m. in.:
<ul>
 <li>URL obrazka - adres (skopiowany z paska przegldarki) do obrazka znajdujcego si w Internecie (koniecznie z przedrostkiem <kbd>http://</kbd>),</li>
 <li>wgrany obrazek - wybrany z listy (zaadowany wczeniej w mediach w panelu administracji) obrazek,</li>
 <li>opis obrazka - opis, ktry wywietla si w przypadku niezaadowania obrazka i jest widoczny np. dla wyszukiwarek, przez co moe mie znaczenie przy wynikach Google,</li>
 <li>tytu - opis obrazka wywietlany po najechaniu na niego kursorem myszy,</li>
 <li>zakadka "prezentacja":
  <ul>
   <li>rozmiary - rozmiary obrazka wywietlanego na stronie,</li>
   <li>odstp - odstp tekstu i innych elementw od obrazka w pionie i poziomie,</li>
   <li>efekt - wybranie pozycji <code>Wywietlanie powikszenia</code> sprawi, e obrazek zachowywa si bdzie jak zdjcie w galerii - po jego klikniciu otworzy si okienko z powikszeniem.</li>
  </ul>
 </li>
</ul>
<br />Ustawienia mona edytowa zaznaczaj istniejcy obrazek klikniciem i klikajc przycisk wstawiania obrazka.
<br /><br />Domylnie kady nowy obrazek jest <a href="?pomoc=wyrownanie">wyrwnany</a> do lewej strony, dziki czemu tekst opywa go z prawej.
By wyczy wyrwnanie naley wybra opcj wyrwnania "brak" w zakadce "prezentacja" opcji obrazka bd klikn przycisk wyrwnania do lewej strony.';
}

function media()
{
echo 'wstawianie mediw</h1>
<div class="img left right"><a href="javascript:void(0)" class="img media"></a></div><div class="clear"></div>
Przycisk pozwala na wstawienie mediw, np. filmu czy animacji, w miejscu kursora.
W otwartym okienku ustawi mona m. in.:
<ul>
 <li>URL - adres (skopiowanym z paska przegldarki) np. do filmu z serwisu YouTube, ktry zostanie wstawiony na stronie,</li>
 <li>wgrane media - wybrany z listy (zaadowany wczeniej w mediach w panelu administracji) obiekt flash.</li>
</ul>
<br />Ustawienia mona edytowa zaznaczaj istniejcy obrazek klikniciem i klikajc przycisk wstawiania obrazka.';
}

function rozwijanie()
{
echo 'wstawianie elementu rozwijanego</h1>
<div class="img left right"><a href="javascript:void(0)" class="img rozwijanie"></a></div><div class="clear"></div>
Przycisk pozwala na wstawienie elementu rozwijanego w miejscu kursora.
Element ten jest jednokomrkow tabel, ktrej komrka podzielona jest na dwie, oddzielone kropkowan lini, czci.
Uytkowik po wejciu na stron zobaczy jedynie grn cz, a po jej klikniciu rozwinie si dolna.
<br /><br />Treci moe by dowolny tekst i elementy, a tabela moe by <a href="?pomoc=tabela">dowolnie modyfikowana</a>.';
}

function spacja()
{
echo 'wstawianie twardej spacji</h1>
<div class="img left right"><a href="javascript:void(0)" class="img spacja"></a></div><div class="clear"></div>
Przycisk pozwala na wstawienie w miejscu kursora twardej spacji.
Spacja ta nie moe zosta przeamana, tzn. w jej miejscu nie moe nastpi przejcie do nowej linii.
Ta waciwo przydatna jest, gdy nie chcemy, by np. na innym komputerze z innymi ustawieniami ekranu dwie czci zwrotu "i inni" wywietliy si w osobnych linijkach.
<br /><br />Twarde spacje mog te by wstawione obok siebie - bd wtedy wielokrotnie wywietlone przez przegldark.';
}

function symbol()
{
echo 'wstawianie symbolu</h1>
<div class="img left right"><a href="javascript:void(0)" class="img symbol"></a></div><div class="clear"></div>
Przycisk otwiera okienko, z ktrego moemy wybra od wstawienia znak nie znajdujcy si na klawiaturze.';
}

function akronim()
{
echo 'wstawianie akronimu</h1>
<div class="img left right"><a href="javascript:void(0)" class="img akronim"></a></div><div class="clear"></div>
Przycisk pozwala doda do zaznaczonego tekstu wyjanienie akronimu, widoczne po najechaniu na niego kursorem myszki.
Jest to przydatne, gdy uywamy w tekcie skrtu, ktrego czytelnik moe nie zna.';
}

function linia()
{
echo 'wstawianie poziomej linii</h1>
<div class="img left right"><a href="javascript:void(0)" class="img linia"></a></div><div class="clear"></div>
Przycisk pozwala wstawi w miejscu kursora poziom lini rozdzielajc.';
}

function widocznosc()
{
echo 'przeczanie widocznoci niewidocznych elementw</h1>
<div class="img left right"><a href="javascript:void(0)" class="img widocznosc"></a></div><div class="clear"></div>
Przycisk pozwala na wczenie bd wyczenie widocznoci w edytorze elementw, ktre nie bd widoczne na stronie, np. granic tabeli nie posiadajcej obramowania.';
}

function fullscreen()
{
echo 'przeczanie trybu penoekranowego</h1>
<div class="img left right"><a href="javascript:void(0)" class="img fullscreen"></a></div><div class="clear"></div>
Przycisk pozwala na wczenie bd wyczenie trybu penoekranowego edytora, tj. w caym oknie przegldarki.';
}

function pokaz_html()
{
echo 'edycja rda HTML</h1>
<div class="img left right"><a href="javascript:void(0)" class="img html"></a></div><div class="clear"></div>
Przycisk otwiera okienko pozwalajce na edycj rda HTML dokumentu.
Mona w nim rcznie wprowadzi wywietlany tekst i elementy, a take wstawi skrypty JavaScript.';
}

function pomoc()
{
echo 'edytor treci</h1>

<div style="font-weight:bold">Pomoc wedug ikon:</div>
<div class="img left"><a href="?pomoc=cofnij" class="img cofnij"></a></div>
<div class="img right"><a href="?pomoc=cofnij" class="img ponow"></a></div>

<div class="img left"><a href="?pomoc=operacje" class="img wytnij"></a></div>
<div class="img"><a href="?pomoc=operacje" class="img kopiuj"></a></div>
<div class="img"><a href="?pomoc=operacje" class="img wklej"></a></div>
<div class="img"><a href="?pomoc=szukaj" class="img szukaj"></a></div>
<div class="img right"><a href="?pomoc=szukaj" class="img zamien"></a></div>

<div class="img left"><a href="?pomoc=formatowanie" class="img formatowanie"></a></div>
<div class="img right"><a href="?pomoc=czyszczenie" class="img czyszczenie"></a></div>

<div class="img left right"><a href="?pomoc=tabela" class="img tabela"></a></div>

<div class="clear" style="height: 3px;"></div>

<div class="img left"><a href="?pomoc=style" class="img bold"></a></div>
<div class="img"><a href="?pomoc=style" class="img italic"></a></div>
<div class="img"><a href="?pomoc=style" class="img under"></a></div>
<div class="img"><a href="?pomoc=style" class="img strike"></a></div>
<div class="img"><a href="?pomoc=indeksy" class="img sub"></a></div>
<div class="img right"><a href="?pomoc=indeksy" class="img sup"></a></div>

<div class="img left"><a href="?pomoc=wyrownanie" class="img lewo"></a></div>
<div class="img"><a href="?pomoc=wyrownanie" class="img srodek"></a></div>
<div class="img"><a href="?pomoc=wyrownanie" class="img prawo"></a></div>
<div class="img right"><a href="?pomoc=wyrownanie" class="img justuj"></a></div>

<div class="clear" style="height: 3px;"></div>

<a href="?pomoc=format" class="button">Akapit</a>
<a href="?pomoc=czcionka" class="button">Czcionka</a>
<a href="?pomoc=rozmiar" class="button">Rozmiar</a>

<div class="clear" style="height: 3px;"></div>

<div class="img left"><a href="?pomoc=kolor" class="img kolor"></a></div>
<div class="img right"><a href="?pomoc=kolor" class="img tlo"></a></div>

<div class="img left"><a href="?pomoc=wciecie" class="img wciecie"></a></div>
<div class="img right"><a href="?pomoc=wciecie" class="img zmniejsz_wciecie"></a></div>

<div class="img left"><a href="?pomoc=lista" class="img punkty"></a></div>
<div class="img right"><a href="?pomoc=lista" class="img numeracja"></a></div>

<div class="img left"><a href="?pomoc=wstaw_link" class="img link"></a></div>
<div class="img"><a href="?pomoc=wstaw_link" class="img usun_link"></a></div>
<div class="img right"><a href="?pomoc=kotwica" class="img kotwica"></a></div>

<div class="clear" style="height: 3px;"></div>

<div class="img left"><a href="?pomoc=obrazek" class="img obrazek"></a></div>
<div class="img"><a href="?pomoc=media" class="img media"></a></div>
<div class="img"><a href="?pomoc=rozwijanie" class="img rozwijanie"></a></div>
<div class="img"><a href="?pomoc=spacja" class="img spacja"></a></div>
<div class="img"><a href="?pomoc=symbol" class="img symbol"></a></div>
<div class="img"><a href="?pomoc=akronim" class="img akronim"></a></div>
<div class="img right"><a href="?pomoc=linia" class="img linia"></a></div>

<div class="img left"><a href="?pomoc=widocznosc" class="img widocznosc"></a></div>
<div class="img"><a href="?pomoc=fullscreen" class="img fullscreen"></a></div>
<div class="img right"><a href="?pomoc=pokaz_html" class="img html"></a></div>

<div class="clear"></div>

<br>
<div style="font-weight:bold;">Pomoc wedug zagadnie:</div>
<ul>
 <li><a href="?pomoc=szukaj">Masowa zamiana sw</a></li>
 <li><a href="?pomoc=formatowanie">Usuwanie formatowania</a></li>
 <li><a href="?pomoc=czyszczenie">Czyszczenie dokumentu</a></li>
 <li><a href="?pomoc=tabela">Wstawianie kilku elementw obok siebie</a></li>
 <li><a href="?pomoc=tabela">Wstawianie tabeli</a></li>
 <li><a href="?pomoc=widocznosc">Granice tabeli</a></li>
 <li><a href="?pomoc=style">Wygld tekstu</a></li>
 <li><a href="?pomoc=indeksy">Wstawianie indeku grnego i dolnego</a></li>
 <li><a href="?pomoc=wyrownanie">Wyrwnanie</a></li>
 <li><a href="?pomoc=format">Nagwki i akapity</a></li>
 <li><a href="?pomoc=czcionka">Czcionka</a></li>
 <li><a href="?pomoc=rozmiar">Rozmiar czcionki</a></li>
 <li><a href="?pomoc=kolor">Kolor tekstu i ta</a></li>
 <li><a href="?pomoc=wciecie">Margines, odstp od krawdzi, wcicie</a></li>
 <li><a href="?pomoc=lista">Lista wypunktowana i numerowana</a></li>
 <li><a href="?pomoc=wstaw_link">Link, hipercze</a></li>
 <li><a href="?pomoc=kotwica">Kotwica</a></li>
 <li><a href="?pomoc=obrazek">Wstawianie obrazka</a></li>
 <li><a href="?pomoc=media">Wstawianie filmu i obiektw flash</a></li>
 <li><a href="?pomoc=rozwijanie">Rozwijany obiekt</a></li>
 <li><a href="?pomoc=spacja">Twarda spacja, blokada przeamania tekstu</a></li>
 <li><a href="?pomoc=symbol">Wstawianie symbolu</a></li>
 <li><a href="?pomoc=akronim">Wstawianie akronimu</a></li>
 <li><a href="?pomoc=linia">Pozioma linia oddzielajca</a></li>
 <li><a href="?pomoc=fullscreen">Edycja penoekranowa</a></li>
 <li><a href="?pomoc=pokaz_html">Edycja rda HTML, wstawianie skryptw JavaScript</a></li>
</ul>';
}

echo '<div id="tresc">
<h1><img src="../../../grafika/std/pomoc-kolo.png" alt="" style="height: 30px; vertical-align: -8px; margin-right: 5px;" />Pomoc: ';

if (function_exists($_GET['pomoc']))
    $_GET['pomoc']();
else
{
    pomoc();
    $_GET['pomoc'] = 'pomoc';
}

echo '</div>';

if ($_GET['pomoc'] != 'pomoc')
    echo '<a href="?pomoc=pomoc" id="powrot"></a>';
?>

</body>

</html>
