/**
 * plugin for tinyMCE by Maciej Radzikowski
 * wstawianie table.rozwijanie na potrzeby rozwijania treści w jQuery
 */
(function() {
tinymce.create('tinymce.plugins.PluginRozwijanie', {
  // funkcja uruchamiania podczas wczytywania wtyczki
  init : function(ed, url) {
    var t = this;
    t.editor = ed;
    
    ed.addCommand('mceCode', function() {
      var wartosc, ed = t.editor, dom = ed.dom, sel = ed.selection, table = true, html = '';
      if (sel.isCollapsed()) wartosc = 'tu_wstaw_tre\u015B\u0107_do_klikni\u0119cia';
      else wartosc = sel.getSel();
      
      if ( ed.dom.getParent(sel.getNode(), 'TD') ) table = false;
      
      if (table) html += '<table style="width: 100%;"><tr><td>';
      html += '<div class="rozwijanie"><div class="rozwin"><p>'+wartosc+'</p></div><div class="rozwiniecie"><p>tu_wstaw_tre\u015B\u0107_rozwijan\u0105_po_klikni\u0119ciu</p></div></div>';
      if (table) html += '</td></tr></table>';
      //var html = '<table class="rozwijanie"><tr><td>'+wartosc+'</td></tr><tr><td>tu_wstaw_tre\u015B\u0107_rozwijan\u0105_po_klikni\u0119ciu</td></tr></table>';
      ed.execCommand('mceInsertContent', false, html);
      ed.addVisual();
    });
    
    /*ed.onNodeChange.add(function(ed, cm, n, co) {
	cm.setDisabled('rozwijanie', n.nodeName == 'TD');
    });*/

    ed.addButton('rozwijanie', {
      title : 'Wstaw rozwijany element',
      cmd : 'mceCode', //metoda wykonywana po nacisnieciu przycisku
      image : url + '/ikona.png' //sciezka do obrazka
    });
  },// end init
  
		getInfo : function() {
			return {
				longname : 'Rozwijany element',
				author : 'Maciej Radzikowski',
				authorurl : 'http://radzikowski.com.pl',
				version : tinymce.majorVersion + "." + tinymce.minorVersion
			};
		}
  
}); //end tinymce.create()

// Rejestrujemy plugin
tinymce.PluginManager.add('rozwijanie', tinymce.plugins.PluginRozwijanie);
})();

